/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.ButtonInput;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DialogInput
extends ButtonInput {
    private static final Object PLACEHOLDER = new Object();
    private Text text;
    private AbstractDialog dialog;
    private Object choosen;
    private int maxlength = 0;
    private ArrayList<FocusListener> focusListeners = new ArrayList();
    private ArrayList<KeyListener> keyListeners = new ArrayList();
    private Object oldValue = PLACEHOLDER;

    public DialogInput(String value) {
        this(value, null);
    }

    public DialogInput(String value, AbstractDialog d) {
        this.value = value;
        this.dialog = d;
        this.addButtonListener(new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((String)"starting dialog");
                try {
                    DialogInput.this.choosen = DialogInput.this.dialog.open();
                    DialogInput.this.text.redraw();
                    DialogInput.this.text.forceFocus();
                }
                catch (OperationCanceledException oce) {
                    Logger.debug((String)"operation cancelled");
                }
                catch (Exception e1) {
                    Logger.error((String)"error while opening dialog", (Throwable)e1);
                }
            }
        });
    }

    public void setDialog(AbstractDialog d) {
        this.dialog = d;
    }

    @Override
    public Object getValue() {
        return this.choosen;
    }

    public String getText() {
        if (this.text != null && !this.text.isDisposed()) {
            return this.text.getText();
        }
        return this.value;
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.value = text;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(text);
        }
    }

    public void setMaxLength(int length) {
        if (length > 0) {
            this.maxlength = length;
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setTextLimit(this.maxlength);
        }
    }

    public int getMaxLength() {
        return this.maxlength;
    }

    @Override
    public void setValue(Object value) {
        this.choosen = value;
    }

    public void setSelection(int start, int end) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setSelection(start, end);
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.focusListeners.add(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.keyListeners.add(listener);
    }

    @Override
    public Control getClientControl(Composite parent) {
        if (this.text != null) {
            return this.text;
        }
        this.text = GUI.getStyleFactory().createText(parent);
        if (this.value != null) {
            this.text.setText(this.value);
        }
        if (this.maxlength > 0) {
            this.text.setTextLimit(this.maxlength);
        }
        for (FocusListener focusListener : this.focusListeners) {
            this.text.addFocusListener(focusListener);
        }
        for (KeyListener keyListener : this.keyListeners) {
            this.text.addKeyListener(keyListener);
        }
        return this.text;
    }

    @Override
    protected void update() throws OperationCanceledException {
        super.update();
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        String s = this.text.getText();
        Color color = null;
        if (this.isMandatory() && (s == null || s.length() == 0)) {
            color = de.willuhn.jameica.gui.util.Color.MANDATORY_BG.getSWTColor();
        }
        this.text.setBackground(color);
    }

    @Override
    public boolean hasChanged() {
        String newValue = this.getText();
        try {
            if (this.oldValue == PLACEHOLDER || this.oldValue == newValue) {
                boolean bl = false;
                return bl;
            }
            boolean bl = newValue == null || !newValue.equals(this.oldValue);
            return bl;
        }
        finally {
            this.oldValue = newValue;
        }
    }
}

